import torch.nn as nn
import torch.nn.functional as F
import pdb


class LFIW(nn.Module):
    def __init__(self, input_shape, args):
        super(LFIW, self).__init__()
        self.args = args

        self.fc1 = nn.Linear(input_shape, args.hidden_size)
        self.rnn = nn.GRUCell(args.hidden_size, args.hidden_size)
        self.fc2 = nn.Linear(args.hidden_size, 1)

    def forward(self, inputs, hidden):

        x = F.relu(self.fc1(inputs))
        h_in = hidden.reshape(-1, self.args.hidden_size)
        h_out = self.rnn(x, h_in)
        q = self.fc2(h_out)
        return q, h_out

    def init_hidden(self):
        # make hidden states on same device as model
        return self.fc1.weight.new(1, self.args.hidden_size).zero_()
    
    def init_weights(self, m):
        if type(m) == nn.Linear:
            nn.init.uniform_(m.weight)
            m.bias.data.fill_(0.0)
